/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.metrics.BaseTestMetricsProvider;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerMainTest
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerMainTest.class);
    private CountDownLatch clientConnected = new CountDownLatch(1);

    @Test
    @Timeout(value=30L)
    public void testNonRecoverableError() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        MainThread main = new MainThread(CLIENT_PORT, true, null);
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        zk.create("/foo1", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData("/foo1", null, null)), (Object)"foobar");
        ZooKeeperServer zooKeeperServer = main.getCnxnFactory().getZooKeeperServer();
        FileTxnSnapLog snapLog = zooKeeperServer.getTxnLogFactory();
        FileTxnSnapLog fileTxnSnapLogWithError = new FileTxnSnapLog(snapLog.getDataDir(), snapLog.getSnapDir()){

            public void commit() throws IOException {
                throw new IOException("Input/output error");
            }
        };
        ZKDatabase newDB = new ZKDatabase(fileTxnSnapLogWithError);
        zooKeeperServer.setZKDatabase(newDB);
        try {
            zk.create("/foo2", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"IOException is expected as error is injected in transaction log commit funtionality");
        }
        catch (Exception exception) {
            // empty catch block
        }
        zk.close();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        fileTxnSnapLogWithError.close();
        main.shutdown();
        main.deleteDirs();
    }

    @Test
    @Timeout(value=30L)
    public void testReadOnlySnapshotDir() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        MainThread main = new MainThread(CLIENT_PORT, true, null);
        File tmpDir = main.tmpDir;
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT / 2), (String)"waiting for server being up");
        main.shutdown();
        File snapDir = new File(main.dataDir, "version-2");
        snapDir.setWritable(false);
        main = new MainThread(CLIENT_PORT, null, false, tmpDir, null);
        main.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT / 2), (String)"waiting for server being up");
        main.shutdown();
        snapDir.setWritable(true);
        main.deleteDirs();
    }

    @Test
    @Timeout(value=30L)
    public void testReadOnlyTxnLogDir() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        MainThread main = new MainThread(CLIENT_PORT, true, null);
        File tmpDir = main.tmpDir;
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT / 2), (String)"waiting for server being up");
        main.shutdown();
        File logDir = new File(main.logDir, "version-2");
        logDir.setWritable(false);
        main = new MainThread(CLIENT_PORT, null, false, tmpDir, null);
        main.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT / 2), (String)"waiting for server being up");
        main.shutdown();
        logDir.setWritable(true);
        main.deleteDirs();
    }

    @Test
    public void testStandalone() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        MainThread main = new MainThread(CLIENT_PORT, true, null);
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.clientConnected = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        Assertions.assertTrue((boolean)this.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Failed to establish zkclient connection!");
        zk.create("/foo", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData("/foo", null, null)), (Object)"foobar");
        zk.close();
        main.shutdown();
        main.join();
        main.deleteDirs();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
    }

    @Test
    public void testWithMinSessionTimeoutGreaterThanMaxSessionTimeout() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        int tickTime = 2000;
        int minSessionTimeout = 41000;
        int maxSessionTimeout = 3900;
        String configs = "maxSessionTimeout=3900\nminSessionTimeout=41000\n";
        MainThread main = new MainThread(CLIENT_PORT, true, "maxSessionTimeout=3900\nminSessionTimeout=41000\n");
        String[] args = new String[]{main.confFile.toString()};
        try {
            main.main.initializeAndRun(args);
            Assertions.fail((String)"Must throw exception as minsessiontimeout > maxsessiontimeout");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidMetricsProvider() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String configs = "metricsProvider.className=BadClass\n";
        MainThread main = new MainThread(CLIENT_PORT, true, "metricsProvider.className=BadClass\n");
        String[] args = new String[]{main.confFile.toString()};
        try {
            main.main.initializeAndRun(args);
            Assertions.fail((String)"Must throw exception as metrics provider is not well configured");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testFaultyMetricsProviderOnStart() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String configs = "metricsProvider.className=" + BaseTestMetricsProvider.MetricsProviderWithErrorInStart.class.getName() + "\n";
        MainThread main = new MainThread(CLIENT_PORT, true, configs);
        String[] args = new String[]{main.confFile.toString()};
        try {
            main.main.initializeAndRun(args);
            Assertions.fail((String)"Must throw exception as metrics provider cannot boot");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testFaultyMetricsProviderOnConfigure() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String configs = "metricsProvider.className=" + BaseTestMetricsProvider.MetricsProviderWithErrorInConfigure.class.getName() + "\n";
        MainThread main = new MainThread(CLIENT_PORT, true, configs);
        String[] args = new String[]{main.confFile.toString()};
        try {
            main.main.initializeAndRun(args);
            Assertions.fail((String)"Must throw exception as metrics provider is cannot boot");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testFaultyMetricsProviderOnStop() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        BaseTestMetricsProvider.MetricsProviderWithErrorInStop.stopCalled.set(false);
        String configs = "metricsProvider.className=" + BaseTestMetricsProvider.MetricsProviderWithErrorInStop.class.getName() + "\n";
        MainThread main = new MainThread(CLIENT_PORT, true, configs);
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.clientConnected = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        Assertions.assertTrue((boolean)this.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Failed to establish zkclient connection!");
        zk.create("/foo", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData("/foo", null, null)), (Object)"foobar");
        zk.close();
        main.shutdown();
        main.join();
        main.deleteDirs();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        Assertions.assertTrue((boolean)BaseTestMetricsProvider.MetricsProviderWithErrorInStop.stopCalled.get());
    }

    @Test
    public void testMetricsProviderConfiguration() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        BaseTestMetricsProvider.MetricsProviderWithConfiguration.httpPort.set(0);
        String configs = "metricsProvider.className=" + BaseTestMetricsProvider.MetricsProviderWithConfiguration.class.getName() + "\nmetricsProvider.httpPort=1234\n";
        MainThread main = new MainThread(CLIENT_PORT, true, configs);
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.clientConnected = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        Assertions.assertTrue((boolean)this.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Failed to establish zkclient connection!");
        zk.create("/foo", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData("/foo", null, null)), (Object)"foobar");
        zk.close();
        main.shutdown();
        main.join();
        main.deleteDirs();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        Assertions.assertEquals((int)1234, (int)BaseTestMetricsProvider.MetricsProviderWithConfiguration.httpPort.get());
    }

    @Test
    public void testMetricsProviderLifecycle() throws Exception {
        ClientBase.setupTestEnv();
        BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.reset();
        int CLIENT_PORT = PortAssignment.unique();
        String configs = "metricsProvider.className=" + BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.class.getName() + "\nmetricsProvider.httpPort=1234\n";
        MainThread main = new MainThread(CLIENT_PORT, true, configs);
        main.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.clientConnected = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        Assertions.assertTrue((boolean)this.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Failed to establish zkclient connection!");
        zk.create("/foo", "foobar".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData("/foo", null, null)), (Object)"foobar");
        zk.close();
        main.shutdown();
        main.join();
        main.deleteDirs();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        Assertions.assertTrue((boolean)BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.configureCalled.get(), (String)"metrics provider lifecycle error");
        Assertions.assertTrue((boolean)BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.startCalled.get(), (String)"metrics provider lifecycle error");
        Assertions.assertTrue((boolean)BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.getRootContextCalled.get(), (String)"metrics provider lifecycle error");
        Assertions.assertTrue((boolean)BaseTestMetricsProvider.MetricsProviderCapturingLifecycle.stopCalled.get(), (String)"metrics provider lifecycle error");
    }

    @Test
    public void testWithOnlyMinSessionTimeout() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        int tickTime = 2000;
        int minSessionTimeout = 3900;
        int maxSessionTimeout = 40000;
        String configs = "minSessionTimeout=3900\n";
        MainThread main = new MainThread(CLIENT_PORT, true, "minSessionTimeout=3900\n");
        main.start();
        String HOSTPORT = "127.0.0.1:" + CLIENT_PORT;
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.verifySessionTimeOut(3900, 3900, HOSTPORT);
        this.verifySessionTimeOut(1900, 3900, HOSTPORT);
        this.verifySessionTimeOut(maxSessionTimeout, maxSessionTimeout, HOSTPORT);
        this.verifySessionTimeOut(maxSessionTimeout + 2000, maxSessionTimeout, HOSTPORT);
        main.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
    }

    @Test
    public void testMinMaxSessionTimeOut() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        int tickTime = 2000;
        int minSessionTimeout = 3900;
        int maxSessionTimeout = 41000;
        String configs = "maxSessionTimeout=41000\nminSessionTimeout=3900\n";
        MainThread main = new MainThread(CLIENT_PORT, true, "maxSessionTimeout=41000\nminSessionTimeout=3900\n");
        main.start();
        String HOSTPORT = "127.0.0.1:" + CLIENT_PORT;
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        this.verifySessionTimeOut(3900, 3900, HOSTPORT);
        this.verifySessionTimeOut(1900, 3900, HOSTPORT);
        this.verifySessionTimeOut(41000, 41000, HOSTPORT);
        this.verifySessionTimeOut(43000, 41000, HOSTPORT);
        main.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
    }

    private void verifySessionTimeOut(int sessionTimeout, int expectedSessionTimeout, String HOSTPORT) throws IOException, KeeperException, InterruptedException {
        this.clientConnected = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper(HOSTPORT, sessionTimeout, (Watcher)this);
        Assertions.assertTrue((boolean)this.clientConnected.await(sessionTimeout, TimeUnit.MILLISECONDS), (String)"Failed to establish zkclient connection!");
        Assertions.assertEquals((int)expectedSessionTimeout, (int)zk.getSessionTimeout(), (String)"Not able to configure the sessionTimeout values");
        zk.close();
    }

    @Test
    public void testJMXRegistrationWithNIO() throws Exception {
        ClientBase.setupTestEnv();
        File tmpDir_1 = ClientBase.createTmpDir();
        ServerCnxnFactory server_1 = this.startServer(tmpDir_1);
        File tmpDir_2 = ClientBase.createTmpDir();
        ServerCnxnFactory server_2 = this.startServer(tmpDir_2);
        server_1.shutdown();
        server_2.shutdown();
        this.deleteFile(tmpDir_1);
        this.deleteFile(tmpDir_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJMXRegistrationWithNetty() throws Exception {
        String originalServerCnxnFactory = System.getProperty("zookeeper.serverCnxnFactory");
        System.setProperty("zookeeper.serverCnxnFactory", NettyServerCnxnFactory.class.getName());
        try {
            ClientBase.setupTestEnv();
            File tmpDir_1 = ClientBase.createTmpDir();
            ServerCnxnFactory server_1 = this.startServer(tmpDir_1);
            File tmpDir_2 = ClientBase.createTmpDir();
            ServerCnxnFactory server_2 = this.startServer(tmpDir_2);
            server_1.shutdown();
            server_2.shutdown();
            this.deleteFile(tmpDir_1);
            this.deleteFile(tmpDir_2);
        }
        finally {
            if (originalServerCnxnFactory == null || originalServerCnxnFactory.isEmpty()) {
                System.clearProperty("zookeeper.serverCnxnFactory");
            } else {
                System.setProperty("zookeeper.serverCnxnFactory", originalServerCnxnFactory);
            }
        }
    }

    private void deleteFile(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.deleteFile(c);
            }
        }
        if (!f.delete() && f.exists()) {
            throw new IOException("Failed to delete file: " + f);
        }
    }

    private ServerCnxnFactory startServer(File tmpDir) throws IOException, InterruptedException {
        int CLIENT_PORT = PortAssignment.unique();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)CLIENT_PORT, (int)-1);
        f.startup(zks);
        Assertions.assertNotNull((Object)zks.jmxServerBean, (String)"JMX initialization failed!");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
        return f;
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.clientConnected.countDown();
        }
    }

    public static class TestZKSMain
    extends ZooKeeperServerMain {
        public void shutdown() {
            super.shutdown();
        }
    }

    public static class MainThread
    extends Thread {
        final File confFile;
        final TestZKSMain main;
        final File tmpDir;
        final File dataDir;
        final File logDir;

        public MainThread(int clientPort, boolean preCreateDirs, String configs) throws IOException {
            this(clientPort, null, preCreateDirs, ClientBase.createTmpDir(), configs);
        }

        public MainThread(int clientPort, Integer secureClientPort, boolean preCreateDirs, String configs) throws IOException {
            this(clientPort, secureClientPort, preCreateDirs, ClientBase.createTmpDir(), configs);
        }

        public MainThread(int clientPort, Integer secureClientPort, boolean preCreateDirs, File tmpDir, String configs) throws IOException {
            super("Standalone server with clientPort:" + clientPort);
            this.tmpDir = tmpDir;
            this.confFile = new File(tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=2000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            if (configs != null) {
                fwriter.write(configs);
            }
            this.dataDir = new File(this.tmpDir, "data");
            this.logDir = new File(this.dataDir.toString() + "_txnlog");
            if (preCreateDirs) {
                if (!this.dataDir.mkdir()) {
                    throw new IOException("unable to mkdir " + this.dataDir);
                }
                if (!this.logDir.mkdir()) {
                    throw new IOException("unable to mkdir " + this.logDir);
                }
                ClientBase.createInitializeFile(this.logDir);
            }
            String normalizedDataDir = PathUtils.normalizeFileSystemPath((String)this.dataDir.toString());
            String normalizedLogDir = PathUtils.normalizeFileSystemPath((String)this.logDir.toString());
            fwriter.write("dataDir=" + normalizedDataDir + "\n");
            fwriter.write("dataLogDir=" + normalizedLogDir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            if (secureClientPort != null) {
                fwriter.write("secureClientPort=" + secureClientPort + "\n");
            }
            fwriter.flush();
            fwriter.close();
            this.main = new TestZKSMain();
        }

        @Override
        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", (Throwable)e);
            }
        }

        public void shutdown() throws IOException {
            this.main.shutdown();
        }

        void deleteDirs() throws IOException {
            this.delete(this.tmpDir);
        }

        void delete(File f) throws IOException {
            if (f.isDirectory()) {
                for (File c : f.listFiles()) {
                    this.delete(c);
                }
            }
            if (!f.delete() && f.exists()) {
                throw new IOException("Failed to delete file: " + f);
            }
        }

        ServerCnxnFactory getCnxnFactory() {
            return this.main.getCnxnFactory();
        }

        public ServerCnxnFactory getSecureCnxnFactory() {
            return this.main.getSecureCnxnFactory();
        }
    }
}

