/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Shell;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ZKUtilTest
extends ClientBase {
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));

    @BeforeAll
    public static void init() {
        testData.mkdirs();
    }

    @Test
    public void testValidateFileInput() throws IOException {
        File file = File.createTempFile("test", ".junit", testData);
        file.deleteOnExit();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput((String)absolutePath);
        Assertions.assertNull((Object)error);
    }

    @Test
    public void testValidateFileInputNotExist() {
        String fileName = UUID.randomUUID().toString();
        File file = new File(testData, fileName);
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput((String)absolutePath);
        Assertions.assertNotNull((Object)error);
        String expectedMessage = "File '" + absolutePath + "' does not exist.";
        Assertions.assertEquals((Object)expectedMessage, (Object)error);
    }

    @Test
    public void testValidateFileInputDirectory() throws Exception {
        File file = File.createTempFile("test", ".junit", testData);
        file.deleteOnExit();
        file.delete();
        file.mkdir();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput((String)absolutePath);
        Assertions.assertNotNull((Object)error);
        String expectedMessage = "'" + absolutePath + "' is a directory. it must be a file.";
        Assertions.assertEquals((Object)expectedMessage, (Object)error);
    }

    @Test
    public void testUnreadableFileInput() throws Exception {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        File file = File.createTempFile("test", ".junit", testData);
        file.setReadable(false, false);
        file.deleteOnExit();
        String absolutePath = file.getAbsolutePath();
        String error = ZKUtil.validateFileInput((String)absolutePath);
        Assertions.assertNotNull((Object)error);
        String expectedMessage = "Read permission is denied on the file '" + absolutePath + "'";
        Assertions.assertEquals((Object)expectedMessage, (Object)error);
    }

    @Test
    public void testListRootPathSuccess() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List list = ZKUtil.listSubTreeBFS((ZooKeeper)zk, (String)"/");
        list.remove("/zookeeper");
        list.remove("/zookeeper/quota");
        list.remove("/zookeeper/config");
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertIterableEquals(Arrays.asList("/", "/a", "/a/b"), (Iterable)list);
    }

    @Test
    public void testListNoneRootPathSuccess() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List aList = ZKUtil.listSubTreeBFS((ZooKeeper)zk, (String)"/a");
        Assertions.assertEquals((int)2, (int)aList.size());
        Assertions.assertIterableEquals(Arrays.asList("/a", "/a/b"), (Iterable)aList);
        List bList = ZKUtil.listSubTreeBFS((ZooKeeper)zk, (String)"/a/b");
        Assertions.assertEquals((int)1, (int)bList.size());
        Assertions.assertIterableEquals(Collections.singletonList("/a/b"), (Iterable)bList);
    }
}

