/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.AckRequestProcessor;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderRequestProcessor;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaceConditionTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(RaceConditionTest.class);
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt;

    @Test(timeout=30000L)
    public void testRaceConditionBetweenLeaderAndAckRequestProcessor() throws Exception {
        this.mt = this.startQuorum();
        QuorumPeer leader = this.getLeader(this.mt);
        long oldLeaderCurrentEpoch = leader.getCurrentEpoch();
        Assert.assertNotNull((String)"Leader should not be null", (Object)leader);
        this.shutdownFollowers(this.mt);
        boolean leaderStateChanged = ClientBase.waitForServerState(leader, 15000, "leaderelection", "following");
        Assert.assertTrue((String)"Failed to bring up the old leader server", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + leader.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)("Leader failed to transition to new state. Current state is " + leader.getServerState()), (leaderStateChanged || leader.getCurrentEpoch() > oldLeaderCurrentEpoch ? 1 : 0) != 0);
    }

    @Override
    @After
    public void tearDown() {
        if (null != this.mt) {
            for (int i = 0; i < SERVER_COUNT; ++i) {
                try {
                    this.mt[i].shutdown();
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
                }
            }
        }
    }

    private QuorumPeerTestBase.MainThread[] startQuorum() throws IOException {
        int i;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        for (i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return new MockTestQPMain();
                }
            };
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        return mt;
    }

    private QuorumPeer getLeader(QuorumPeerTestBase.MainThread[] mt) {
        for (int i = mt.length - 1; i >= 0; --i) {
            QuorumPeer quorumPeer = mt[i].getQuorumPeer();
            if (quorumPeer == null || QuorumPeer.ServerState.LEADING != quorumPeer.getPeerState()) continue;
            return quorumPeer;
        }
        return null;
    }

    private void shutdownFollowers(QuorumPeerTestBase.MainThread[] mt) {
        for (int i = 0; i < mt.length; ++i) {
            CustomQuorumPeer quorumPeer = (CustomQuorumPeer)mt[i].getQuorumPeer();
            if (quorumPeer == null || QuorumPeer.ServerState.FOLLOWING != quorumPeer.getPeerState()) continue;
            quorumPeer.setStopPing(true);
        }
    }

    private static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        private MockTestQPMain() {
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new CustomQuorumPeer();
        }
    }

    private static class MockProposalRequestProcessor
    extends ProposalRequestProcessor {
        public MockProposalRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
            super(zks, nextProcessor);
            AckRequestProcessor ackProcessor = new AckRequestProcessor(zks.getLeader());
            this.syncProcessor = new MockSyncRequestProcessor((ZooKeeperServer)zks, (RequestProcessor)ackProcessor);
        }
    }

    private static class MockSyncRequestProcessor
    extends SyncRequestProcessor {
        public MockSyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
            super(zks, nextProcessor);
        }

        public void shutdown() {
            Request request = new Request(null, 0L, 0, 2, ByteBuffer.wrap("/deadLockIssue".getBytes()), null);
            this.processRequest(request);
            super.shutdown();
        }
    }

    private static class CustomQuorumPeer
    extends QuorumPeer {
        private boolean stopPing;

        public void setStopPing(boolean stopPing) {
            this.stopPing = stopPing;
        }

        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            return new Follower(this, new FollowerZooKeeperServer(logFactory, (QuorumPeer)this, this.getZkDb())){

                protected void processPacket(QuorumPacket qp) throws Exception {
                    if (stopPing && qp.getType() == 5) {
                        LOG.info("Follower skipped ping");
                        throw new SocketException("Socket time out while sending the ping response");
                    }
                    super.processPacket(qp);
                }
            };
        }

        protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException, X509Exception {
            LeaderZooKeeperServer zk = new LeaderZooKeeperServer(logFactory, this, this.getZkDb()){

                protected void setupRequestProcessors() {
                    FinalRequestProcessor finalProcessor = new FinalRequestProcessor((ZooKeeperServer)this);
                    Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor((RequestProcessor)finalProcessor, this.getLeader());
                    this.commitProcessor = new CommitProcessor((RequestProcessor)toBeAppliedProcessor, Long.toString(this.getServerId()), false, this.getZooKeeperServerListener());
                    this.commitProcessor.start();
                    MockProposalRequestProcessor proposalProcessor = new MockProposalRequestProcessor(this, (RequestProcessor)this.commitProcessor);
                    proposalProcessor.initialize();
                    this.prepRequestProcessor = new PrepRequestProcessor((ZooKeeperServer)this, (RequestProcessor)proposalProcessor);
                    this.prepRequestProcessor.start();
                    this.firstProcessor = new LeaderRequestProcessor((LeaderZooKeeperServer)this, (RequestProcessor)this.prepRequestProcessor);
                }
            };
            return new Leader((QuorumPeer)this, zk);
        }
    }
}

