/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.BKDistributedLogNamespace;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.bk.LedgerAllocatorPool;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestBKLogWriteHandler
extends TestDistributedLogBase {
    @Rule
    public TestName runtime = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAbortTransactionOnStartLogSegment() throws Exception {
        URI uri = this.createDLMURI("/" + this.runtime.getMethodName());
        this.ensureURICreated(this.zkc, uri);
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setEnableLedgerAllocatorPool(true);
        confLocal.setLedgerAllocatorPoolCoreSize(1);
        confLocal.setLedgerAllocatorPoolName("test-allocator-pool");
        BKDistributedLogNamespace namespace = (BKDistributedLogNamespace)NamespaceBuilder.newBuilder().conf(confLocal).uri(uri).build();
        DistributedLogManager dlm = namespace.openLog("test-stream");
        FailpointUtils.setFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_StartLogSegmentOnAssignLogSegmentSequenceNumber, (FailpointUtils.FailPointActions)FailpointUtils.FailPointActions.FailPointAction_Throw);
        try {
            AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(1L)));
            Assert.fail((String)"Should fail opening the writer");
        }
        catch (IOException writer) {
        }
        finally {
            FailpointUtils.removeFailpoint((FailpointUtils.FailPointName)FailpointUtils.FailPointName.FP_StartLogSegmentOnAssignLogSegmentSequenceNumber);
        }
        LedgerAllocator allocator = ((BKNamespaceDriver)namespace.getNamespaceDriver()).getLedgerAllocator();
        Assert.assertTrue((boolean)(allocator instanceof LedgerAllocatorPool));
        LedgerAllocatorPool allocatorPool = (LedgerAllocatorPool)allocator;
        Assert.assertEquals((long)0L, (long)allocatorPool.obtainMapSize());
        AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        writer.write(DLMTestUtil.getLogRecordInstance(1L));
        Utils.close((AsyncCloseable)writer);
    }
}

