/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ACLTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    @Test
    public void testIPAuthenticationIsValidCIDR() throws Exception {
        IPAuthenticationProvider prov = new IPAuthenticationProvider();
        Assert.assertTrue((String)"testing no netmask", (boolean)prov.isValid("127.0.0.1"));
        Assert.assertTrue((String)"testing single ip netmask", (boolean)prov.isValid("127.0.0.1/32"));
        Assert.assertTrue((String)"testing lowest netmask possible", (boolean)prov.isValid("127.0.0.1/0"));
        Assert.assertFalse((String)"testing netmask too high", (boolean)prov.isValid("127.0.0.1/33"));
        Assert.assertFalse((String)"testing netmask too low", (boolean)prov.isValid("10.0.0.1/-1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyIpAuthDefault() throws Exception {
        String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        ClientBase.setupTestEnv();
        File tmpDir = ClientBase.createTmpDir();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            ClientBase.createZKClient(HOSTPORT);
            for (ServerCnxn cnxn : f.getConnections()) {
                boolean foundID = false;
                for (Id id : cnxn.getAuthInfo()) {
                    if (!id.getScheme().equals("ip")) continue;
                    foundID = true;
                    break;
                }
                Assert.assertTrue((boolean)foundID);
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            System.clearProperty("zookeeper.serverCnxnFactory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisconnectedAddAuth() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
                zk.addAuthInfo("digest", "pat:test".getBytes());
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcls() throws Exception {
        String path;
        ZooKeeper zk;
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            zk = ClientBase.createZKClient(HOSTPORT);
            LOG.info("starting creating acls");
            for (int i = 0; i < 100; ++i) {
                path = "/" + i;
                zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            int size = zks.getZKDatabase().getAclSize();
            Assert.assertTrue((String)"size of the acl map ", (2 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            for (int j = 100; j < 200; ++j) {
                path = "/" + j;
                ACL acl = new ACL();
                acl.setPerms(0);
                Id id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                ArrayList<ACL> list = new ArrayList<ACL>();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assert.assertTrue((String)"size of the acl map ", (102 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            zk = ClientBase.createZKClient(HOSTPORT);
            Assert.assertTrue((String)"acl map ", (102 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            for (int j = 200; j < 205; ++j) {
                path = "/" + j;
                ACL acl = new ACL();
                acl.setPerms(0);
                Id id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                ArrayList<ACL> list = new ArrayList<ACL>();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assert.assertTrue((String)"acl map ", (107 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            zk.close();
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:{} {} {}", new Object[]{event.getState(), event.getType(), event.getPath()});
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            if (this.startSignal != null && this.startSignal.getCount() > 0L) {
                LOG.info("startsignal.countDown()");
                this.startSignal.countDown();
            } else {
                LOG.warn("startsignal {}", (Object)this.startSignal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullACL() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        try {
            try {
                zk.create("/foo", "foo".getBytes(), null, CreateMode.PERSISTENT);
                Assert.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.create("/foo", "foo".getBytes(), null, CreateMode.PERSISTENT, null);
                Assert.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.setACL("/foo", null, 0);
                Assert.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
        }
        finally {
            zk.close();
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullValueACL() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        try {
            ArrayList<Object> acls = new ArrayList<Object>();
            acls.add(null);
            try {
                zk.create("/foo", "foo".getBytes(), acls, CreateMode.PERSISTENT);
                Assert.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.create("/foo", "foo".getBytes(), acls, CreateMode.PERSISTENT, null);
                Assert.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.setACL("/foo", acls, -1);
                Assert.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
        }
        finally {
            zk.close();
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }
}

