/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseDelegateProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterProcessor
extends BaseDelegateProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FilterProcessor.class);
    private final CamelContext context;
    private String id;
    private String routeId;
    private final Predicate predicate;
    private transient long filtered;
    private String statusPropertyName;

    public FilterProcessor(CamelContext context, Predicate predicate, Processor processor) {
        super(processor);
        this.context = context;
        this.predicate = predicate;
    }

    public String getStatusPropertyName() {
        return this.statusPropertyName;
    }

    public void setStatusPropertyName(String statusPropertyName) {
        this.statusPropertyName = statusPropertyName;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.predicate.init(this.context);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean matches = false;
        try {
            matches = this.matches(exchange);
            if (this.statusPropertyName != null) {
                exchange.setProperty(this.statusPropertyName, (Object)matches);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (matches) {
            return this.processor.process(exchange, callback);
        }
        callback.done(true);
        return true;
    }

    public boolean matches(Exchange exchange) {
        boolean matches = this.predicate.matches(exchange);
        LOG.debug("Filter matches: {} for exchange: {}", (Object)matches, (Object)exchange);
        if (matches) {
            ++this.filtered;
        }
        return matches;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTraceLabel() {
        return "filter[if: " + String.valueOf(this.predicate) + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public long getFilteredCount() {
        return this.filtered;
    }

    public void reset() {
        this.filtered = 0L;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.reset();
        ServiceHelper.startService((Object)this.predicate);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.predicate);
        super.doStop();
    }
}

