/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;

public class DelegateAsyncProcessor
extends AsyncProcessorSupport
implements DelegateProcessor,
Navigate<Processor> {
    protected AsyncProcessor processor;

    public DelegateAsyncProcessor() {
    }

    public DelegateAsyncProcessor(AsyncProcessor processor) {
        if (processor == this) {
            throw new IllegalArgumentException("Recursive DelegateAsyncProcessor!");
        }
        this.processor = processor;
    }

    public DelegateAsyncProcessor(Processor processor) {
        this(AsyncProcessorConverterHelper.convert(processor));
    }

    public String toString() {
        return "DelegateAsync[" + String.valueOf(this.processor) + "]";
    }

    public AsyncProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(AsyncProcessor processor) {
        this.processor = processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processor});
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    public boolean hasNext() {
        return this.processor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add((Processor)this.processor);
        return answer;
    }
}

